% -------------------------------------------------
% Este script hace una grfica en la que se muestra
% cmo depende el error de truncamiento del mtodo de Euler
% Este script requiere que en el espacio de trabajo exista la
% funcin feuler.
% La ecuacin diferencial que se resuelve es
% dy/dx = f(x,y;k) = - k*y:
% -----------------------------------------------------------

%Definicion de funciones y parametros iniciales%
k=1;
fun = @(t,y) -k*y;
fexact = @(t,y0) y0*exp(-k*t);
y0=100;
t0=0;
tf=5;
Np=20;  % Nmero de puntos en la figura

%Calculamos el maximo error de truncamiento para cada paso%
e=zeros(1,Np);
h=zeros(1,Np);
Nh = 10:10:10*Np;
for j=1:1:Np
    [t,y]=feuler(fun,t0,tf,y0,Nh(j));
    yp=fexact(t,y0);
    el=abs(yp-y);
    e(j)=max(el);
    h(j)=(tf-t0)/Nh(j); % h es el tamao del paso
end

%Ajustamos los errores de la forma e=c*h%
xy=e.*h;
yy=e.*e;
a=sum(yy);
b=sum(xy);
c=a/b;
efit=c*h;

%Representamos%
loglog(h,e,'o',h,efit,'-k');
xlabel('h');
ylabel('Error global de truncamiento');
title('Mtodo de Euler');
legend('Error numrico','E=cte*h');

